$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#campostuto",
        popover: {
          title: "Dados Gerais",
          description: "Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.",
          position: "top",
        },
      },
      {
        element: "#txtCodigo",
        popover: {
          title: "Campos Obrigatórios",
          description:
            "Aqui adicionamos o código para o CSOSN.",
          position: "top",
        },
      },
      {
        element: "#txtDescricao",
        popover: {
          title: "Campos Obrigatórios",
          description:
            "Neste campo adicionamos a descrição para o CSOSN.",
          position: "top",
        },
      },
      {
        element: "#tutorialTipo",
        popover: {
          title: "Tipo ICMS",
          description:
            "Aqui selecionamos qual o tipo de Tributação ICMS.",
          position: "top",
        },
      },
      {
        element: "#btnVoltar",
        popover: {
          title: "Botão Voltar",
          description:
            "Ao clicar nesse botão você retorna para a tela de consulta.",
          position: "left",
        },
      },
      {
        element: "#btnGravar",
        popover: {
          title: "Botão Gravar",
          description: "Clique aqui para gravar o CSOSN.",
          position: "left",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  let queryString = window.location.href;
  let parametros = queryString.split("/");
  let csosn = parametros[parametros.length - 1];

  $("#btnVoltar").on("click", async function () {
    await deletaRegistro("CSOSN", getCookie("usuario"), csosn);
    window.location.href = `${BASE_URI}/csosn`;
  });

  $(document).ready(async function () {
    $("#msform").validate({
      debug: false,
      ignore: "",
      rules: {
        txtCodigo: {
          required: true,
        },
        txtDescricao: {
          required: true,
        },
      },
      messages: {
        txtCodigo: {
          required: "Informe um código válido.",
        },
        txtDescricao: {
          required: "Informe uma descrição válida.",
        },
      },
      errorElement: "span",
      errorPlacement(error, element) {
        error.addClass("invalid-feedback");
        element.closest(".form-group").append(error);
      },
      highlight(element) {
        $(element).addClass("is-invalid");
      },
      unhighlight(element) {
        $(element).removeClass("is-invalid");
      },
    });

    if (csosn != "" && csosn != "create") {
      if ((await liberarRegistro("CSOSN", csosn)) == false) {
        window.location.href = "../csosn";
      } else {
        carregaDados(csosn);
      }
    }

    async function carregaDados(csosnCarrega) {
      try {
        $.LoadingOverlay("show");
        try {
          let response = await requisicao(
            "GET",
            "/Sisplan/Funcoes/v1/pesquisa?",
            `JSON={ 
                            "tabela":"tabcsosn", 
                            "camposSelect":["codigo", "descricao", "icms"], 
                            "where": ["codigo = '${csosnCarrega}'"]}`,
            null
          );
          if (!response) {
            return;
          }
          let jsonStr = await response.json();
          if (response.status != 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
          }

          $("#txtCodigo").attr("readonly", true);

          $("#txtCodigo").val(jsonStr.RESULT[0][0].CODIGO);
          $("#txtDescricao").val(jsonStr.RESULT[0][0].DESCRICAO);

          $('#radioBase').prop('checked', jsonStr.RESULT[0][0].ICMS == '' || jsonStr.RESULT[0][0].ICMS == '1');
          $('#radioIsentas').prop('checked', jsonStr.RESULT[0][0].ICMS == '2');
          $('#radioOutras').prop('checked', jsonStr.RESULT[0][0].ICMS == '3');
        } catch (error) {
          console.error(error);
          msgErro(`Não foi possível buscar os dados do preço: ${error}`);
        }
      } finally {
        $.LoadingOverlay("hide");
      }
    }

    $(".radio-group .radio").click(function () {
      $(this).parent().find(".radio").removeClass("selected");
      $(this).addClass("selected");
    });

    $(".submit").click(function () {
      return false;
    });
  });

  $("#txtCodigo").change(async function () {
    try {
      $.LoadingOverlay("show");
      try {
        let response = await requisicao(
          "GET",
          "/Sisplan/Funcoes/v1/pesquisa?",
          `JSON={ "tabela":"tabcsosn", 
                "camposSelect":["codigo"], 
                "where": ["codigo = '${$("#txtCodigo").val()}'"]}`,
          null
        );

        if (!response) {
          return;
        }
        let jsonStr = await response.json();
        if (jsonStr.RESULT[0].length > 0) {
          msgAlerta("CSOSN já cadastrado.");
          $("#txtCodigo").val("");
        }
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  $("#btnGravar").click(async function () {
    try {
      let validator = $("#msform").validate();
      validator.form();
      let erros = 0;
      erros = validator.numberOfInvalids();

      if (erros == 0) {
        $.LoadingOverlay("show");

        let csosnClasse = {};

        csosnClasse.CODIGO = $("#txtCodigo").val();
        csosnClasse.DESCRICAO = $("#txtDescricao").val().toUpperCase();
        csosnClasse.ICMS = $('#radioBase').prop('checked') ? '1' : ($('#radioIsentas').prop('checked') ? '2' : '3');

        let response = await requisicao(
          "POST",
          "/Sisplan/Cadastros/v1/csosn?",
          `JSON=${encodeURIComponent(JSON.stringify(csosnClasse))}`,
          null
        );

        if (!response) {
          $.LoadingOverlay("hide");
          return;
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
          $.LoadingOverlay("hide");
          msgErro(jsonStr.mensagem);
          return;
        }
        $.LoadingOverlay("hide");
        toastr
          .success("Cadastro efetuado com sucesso!", "Confirmação", {
            toastClass: "alert",
            iconClasses: {
              error: "alert-error",
              info: "alert-info",
              success: "alert-success",
              warning: "alert-warning",
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
            onHidden() {
              window.location.href = `${BASE_URI}/csosn`;
            },
          })
          .css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px",
          });
      }
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
      msgErro(`Não foi possível gravar os dados da situação: ${error}`);
    }
  });
});
